﻿''' <summary>
'''值对的泛型容器
''' </summary>
''' <typeparam name="T">第一个值类型</typeparam>
''' <typeparam name="V">第二个值类型</typeparam>
''' <remarks>可用于传递值对；
'''类型 T 和 V 是参数；
'''使用 Matches 函数比较 Pair 对象。
''' </remarks>
Public Class Pair(Of T, V)

    '内部变量
    '注意类型 T 和 V 是如何变化的。
    Private fVal As T = Nothing
    Private sVal As V = Nothing

    '测试第一个和第二个 Pair 值的类型和值是否匹配。
    Public Function Matches(ByVal value As Pair(Of T, V)) As Boolean
        If value IsNot Me Then
            If value.FirstValue.Equals(Me.FirstValue) Then
                If value.SecondValue.Equals(Me.SecondValue) Then
                    Return True
                Else
                    Return False
                End If
            Else
                Return False
            End If
        End If
    End Function


    Public Property FirstValue() As T
        Get
            Return fVal
        End Get
        Set(ByVal value As T)
            fVal = value
        End Set
    End Property

    Public Property SecondValue() As V
        Get
            Return sVal
        End Get
        Set(ByVal value As V)
            sVal = value
        End Set
    End Property

End Class